//Dustin Soodak


//
//Behavior 023: shot 15
//serial piano. hue of headlights proportional to frequency of note
//Preferably use serial port program that doesn't require pressing ENTER to send characters
//
#include "MiscHardware.h"
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  PlayChirp(1000, 50);SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  PlayChirp(1000, 0);SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();  
  Serial.println("play characters ` to = (space to change mode)");     
}
char ch=0,mode=0;
int freq;
int r,g,b;
void loop(){
  if (Serial.available() > 0){
    // read the incoming byte:
    ch=Serial.read();
    switch(ch){
    case '`':freq=NOTE_C6;break;
    case '1':freq=NOTE_CS6;break;
    case '2':freq=NOTE_D6;break;
    case '3':freq=NOTE_DS6;break;
    case '4':freq=NOTE_E6;break;
    case '5':freq=NOTE_F6;break;
    case '6':freq=NOTE_FS6;break;
    case '7':freq=NOTE_G6;break;
    case '8':freq=NOTE_GS6;break;
    case '9':freq=NOTE_A6;break;
    case '0':freq=NOTE_AS6;break;
    case '-':freq=NOTE_B6;break;
    case '=':freq=NOTE_C7;break;
    case ' ':
      mode=!mode;
      if(mode){
        SetPixelRGB(1,20,0,0);RefreshPixels();
      }
      else{
        SetAllPixelsRGB(0,0,0);RefreshPixels();
      }
      freq=0;//freq=0 to turn off if mode==0 and to stay off if mode==1 
    break;
    }
    if(mode==0){
      RestartTimer();
    }
    if(freq==0)
      PlayChirp(100,0);//amplitude 0 to turn off
    else{
      PlayChirp(freq,50);
      r=255-abs((int32_t)(freq-NOTE_C6))*255/((NOTE_C7-NOTE_C6)/2);
      if(r<0)r=0;
      g=255-abs((int32_t)(freq-(NOTE_C7+NOTE_C6)/2))*255/((NOTE_C7-NOTE_C6)/2);
      if(g<0)g=0;
      b=255-abs((int32_t)(freq-NOTE_C7))*255/((NOTE_C7-NOTE_C6)/2);
      if(b<0)b=0;
      Serial.print(r,DEC);
      Serial.print(" ");
      Serial.print(g,DEC);
      Serial.print(" ");
      Serial.println(b,DEC);
      SetPixelRGB(5,r,g,b);SetPixelRGB(6,r,g,b);RefreshPixels();
    }   
  }
  if(mode==0){
    if(GetTime()>100){
      PlayChirp(100,0);//amplitude 0 to turn off
      SetAllPixelsRGB(0,0,0);RefreshPixels();
    } 
  }
}//end loop()


